/*
 * Copyright 2019 NXP
 * All rights reserved.
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _LCL_UTILS_H_
#define _LCL_UTILS_H_

/*==================================================================================================
 Include Files
==================================================================================================*/
#include "EmbeddedTypes.h"
#ifdef ENABLE_PROFILING
#include "fsl_os_abstraction.h"
#include "board.h"
#include "fsl_device_registers.h"
#endif

#ifdef LCL_USE_MEM_MANAGER
#include "MemManager.h"
#else
#include <stdlib.h>
#endif
/*==================================================================================================
 Public macros
==================================================================================================*/

#if defined(DEBUG) && !defined(GCOV_DO_COVERAGE)
#define LCL_ASSERT(c)                do { if(!(c)) {/*__BKPT(0)*/ while(TRUE) {}} } while(FALSE)
#else
#define LCL_ASSERT(c)
#endif

#if defined(LCL_COVERAGE)
#define LCL_STATIC extern
#else
#define LCL_STATIC static
#endif

#ifdef LCL_USE_MEM_MANAGER
#define LCLMemAlloc(x)     MEM_BufferAlloc(x)
#define LCLMemCalloc(x,y)  MEM_CallocAlt(x, y)
#define LCLMemFree(x)      (void)MEM_BufferFree(x)
#else
#define LCLMemAlloc(x)     malloc(x)
#define LCLMemCalloc(x,y)  calloc(x, y)
#define LCLMemFree(x)      free(x)
#endif

/* Profiling */
#ifdef ENABLE_PROFILING

extern unsigned long oveflowTickCounter;
#define DEBUG_DWT_CYCLE_CNT_START() \
    int ret; \
    ret = SysTick_Config(SysTick_LOAD_RELOAD_Msk); \
    LCL_ASSERT(ret == 0); \
    oveflowTickCounter = 0;
#define DEBUG_DWT_CYCLE_CNT_RESET() \
    SysTick->VAL   = 0UL; \
    oveflowTickCounter = 0;
#define DEBUG_DWT_CYCLE_CNT_FETCH(storage) \
    storage = oveflowTickCounter << 24; \
    storage |= (SysTick_LOAD_RELOAD_Msk - SysTick->VAL); \
    SysTick->VAL   = 0UL; \
    oveflowTickCounter = 0;
#else
#define DEBUG_DWT_CYCLE_CNT_START()
#define DEBUG_DWT_CYCLE_CNT_FETCH(s)
#define DEBUG_DWT_CYCLE_CNT_RESET()
#endif

#define LCL_GET_AGC_INDEX ((XCVR_RX_DIG->AGC_STAT & XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_MASK) >> XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_SHIFT)
#define LCL_GET_CFO_EST   ((XCVR_2P4GHZ_PHY->STAT0 & XCVR_2P4GHZ_PHY_STAT0_CFO_EST_MASK) >> XCVR_2P4GHZ_PHY_STAT0_CFO_EST_SHIFT)
#define LCL_GET_RSSI      ((GENFSK->XCVR_STS & GENFSK_XCVR_STS_RSSI_MASK) >> GENFSK_XCVR_STS_RSSI_SHIFT)
    
/*==================================================================================================
 Public type definitions
==================================================================================================*/
/*! @brief status return codes for LCL module. */
typedef enum
{
    glclStatusSuccess = 0,   /*!< Success */
    glclStatusInvalidArgs,   /*!< Invalid arguments */
    glclStatusInvalidState,  /*!< Invalid state */
    glclStatusFail,          /*!< Fail */
    glclStatusOutOfMemory    /*!< Out of memory */
} lclStatus_t;


/*==================================================================================================
 Public functions
==================================================================================================*/
uint8_t LCL_lockAgc(uint8_t idx);
void LCL_unlockAgc(void);
void LCL_enableCFOestimateOverride(uint32_t ovrd);
void LCL_disableCFOestimateOverride(void);

#endif //_LCL_UTILS_H_
